//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import "private"

UiSpinBoxBase {
    id : uiSpinBox

    horizontalMargin : 0
    buttonOpacity    : 0

    Rectangle {
        id : background

        anchors {
            right : parent ? parent.right : undefined
        }
        width   : parent.width + 6
        height  : parent.height
        z       : -1
        opacity : 0

        border {
            width : 1
            color : UiColors.getColor(UiColors.ControlGrey20)
        }

        states : [
            State {
                name : "focus"
                when : activeFocus

                PropertyChanges {
                    target        : uiSpinBox
                    buttonOpacity : 1
                }
                PropertyChanges {
                    target       : background
                    opacity      : 1
                    border.color : UiColors.getColor(UiColors.SelectionGreen)
                }
            },
            State {
                name : "hover"
                when : uiSpinBox.hovered

                PropertyChanges {
                    target        : uiSpinBox
                    buttonOpacity : 1
                }
                PropertyChanges {
                    target       : background
                    opacity      : 1
                    border.color : UiColors.getColor(UiColors.HoverGreen)
                }
            }
        ]
    }
}
